/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public abstract class CableBase
extends BlockCyclic
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<EnumConnectType> DOWN = EnumProperty.m_61587_((String)"down", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> UP = EnumProperty.m_61587_((String)"up", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> NORTH = EnumProperty.m_61587_((String)"north", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> SOUTH = EnumProperty.m_61587_((String)"south", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> WEST = EnumProperty.m_61587_((String)"west", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> EAST = EnumProperty.m_61587_((String)"east", EnumConnectType.class);
    public static final Map<Direction, EnumProperty<EnumConnectType>> FACING_TO_PROPERTY_MAP = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), p -> {
        p.put(Direction.NORTH, NORTH);
        p.put(Direction.EAST, EAST);
        p.put(Direction.SOUTH, SOUTH);
        p.put(Direction.WEST, WEST);
        p.put(Direction.UP, UP);
        p.put(Direction.DOWN, DOWN);
    });
    private static final double top = 16.0;
    private static final double bot = 0.0;
    private static final double C = 8.0;
    private static final double w = 2.0;
    private static final double sm = 6.0;
    private static final double lg = 10.0;
    protected static final VoxelShape AABB = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    protected static final VoxelShape AABB_UP = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected static final VoxelShape AABB_DOWN = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    protected static final VoxelShape AABB_NORTH = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0);
    protected static final VoxelShape AABB_SOUTH = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0);
    protected static final VoxelShape AABB_WEST = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    protected static final VoxelShape AABB_EAST = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);

    static boolean shapeConnects(BlockState state, EnumProperty<EnumConnectType> dirctionProperty) {
        return ((EnumConnectType)((Object)state.m_61143_(dirctionProperty))).isConnected();
    }

    public static VoxelShape createShape(BlockState state) {
        VoxelShape shape = AABB;
        if (CableBase.shapeConnects(state, UP)) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)AABB_UP, (BooleanOp)BooleanOp.f_82695_);
        }
        if (CableBase.shapeConnects(state, DOWN)) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)AABB_DOWN, (BooleanOp)BooleanOp.f_82695_);
        }
        if (CableBase.shapeConnects(state, WEST)) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)AABB_WEST, (BooleanOp)BooleanOp.f_82695_);
        }
        if (CableBase.shapeConnects(state, EAST)) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)AABB_EAST, (BooleanOp)BooleanOp.f_82695_);
        }
        if (CableBase.shapeConnects(state, NORTH)) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)AABB_NORTH, (BooleanOp)BooleanOp.f_82695_);
        }
        if (CableBase.shapeConnects(state, SOUTH)) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)AABB_SOUTH, (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    public CableBase(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (hit.m_82434_() == null) {
            return super.m_6227_(state, world, pos, player, handIn, hit);
        }
        if (handIn != InteractionHand.MAIN_HAND) {
            return super.m_6227_(state, world, pos, player, handIn, hit);
        }
        ItemStack stack = player.m_21120_(handIn);
        if (!stack.m_204117_(DataTags.WRENCH)) {
            boolean hasExtractor = false;
            for (Direction side : Direction.values()) {
                EnumConnectType connection = (EnumConnectType)((Object)state.m_61143_((Property)FACING_TO_PROPERTY_MAP.get(side)));
                if (!connection.isExtraction()) continue;
                hasExtractor = true;
                break;
            }
            if (hasExtractor && (this == BlockRegistry.ITEM_PIPE.get() || this == BlockRegistry.FLUID_PIPE.get())) {
                if (!world.f_46443_) {
                    BlockEntity tileEntity = world.m_7702_(pos);
                    if (tileEntity instanceof MenuProvider) {
                        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)tileEntity), (BlockPos)tileEntity.m_58899_());
                    } else {
                        throw new IllegalStateException("Our named container provider is missing!");
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return super.m_6227_(state, world, pos, player, handIn, hit);
        }
        float hitLimit = 0.28f;
        Direction sideToToggle = hit.m_82434_();
        double hitX = hit.m_82450_().f_82479_ - (double)pos.m_123341_();
        double hitY = hit.m_82450_().f_82480_ - (double)pos.m_123342_();
        double hitZ = hit.m_82450_().f_82481_ - (double)pos.m_123343_();
        if (hitX < (double)0.28f) {
            sideToToggle = Direction.WEST;
        } else if (hitX > (double)0.72f) {
            sideToToggle = Direction.EAST;
        } else if (hitY < (double)0.28f) {
            sideToToggle = Direction.DOWN;
        } else if (hitY > (double)0.72f) {
            sideToToggle = Direction.UP;
        } else if (hitZ < (double)0.28f) {
            sideToToggle = Direction.NORTH;
        } else if (hitZ > (double)0.72f) {
            sideToToggle = Direction.SOUTH;
        }
        EnumProperty<EnumConnectType> prop = FACING_TO_PROPERTY_MAP.get(sideToToggle);
        if (state.m_61138_(prop)) {
            EnumConnectType status = (EnumConnectType)((Object)state.m_61143_(prop));
            BlockState newState = state;
            boolean updatePost = false;
            switch (status) {
                case BLOCKED: {
                    newState = (BlockState)state.m_61124_(prop, (Comparable)((Object)EnumConnectType.NONE));
                    updatePost = true;
                    break;
                }
                case INVENTORY: 
                case NONE: {
                    newState = (BlockState)state.m_61124_(prop, (Comparable)((Object)EnumConnectType.CABLE));
                    break;
                }
                case CABLE: {
                    newState = (BlockState)state.m_61124_(prop, (Comparable)((Object)EnumConnectType.BLOCKED));
                }
            }
            if (world.m_8055_(pos).m_60734_() == this && world.m_46597_(pos, newState)) {
                if (updatePost) {
                    newState.m_60728_(sideToToggle, world.m_8055_(pos.m_142300_(sideToToggle)), (LevelAccessor)world, pos, pos.m_142300_(sideToToggle));
                }
                player.m_6674_(handIn);
                if (world.f_46443_) {
                    UtilSound.playSound((Entity)player, SoundRegistry.THUNK, 0.2f, 1.0f);
                }
            }
        }
        return super.m_6227_(state, world, pos, player, handIn, hit);
    }

    public static boolean isCableBlocked(BlockState blockState, Direction side) {
        if (side == null) {
            return false;
        }
        EnumProperty<EnumConnectType> property = FACING_TO_PROPERTY_MAP.get(side);
        return blockState.m_60734_() instanceof CableBase && blockState.m_61138_(property) && !((EnumConnectType)((Object)blockState.m_61143_(property))).isUnBlocked();
    }
}

